#!/bin/bash

cat << EOF
# if you experience problems, check
# http://www.rsyslog.com/troubleshoot for assistance

# rsyslog v3: load input modules
# If you do not load inputs, nothing happens!
# You may need to set the module load path if modules are not found.
#
# Ported from debian's sysklogd.conf

# Activate debug
# *.* /var/log/debugfmt;RSYSLOG_DebugFormat

\$ModLoad immark   # provides --MARK-- message capability
\$ModLoad imuxsock # provides support for local system logging (e.g. via logger command)
\$ModLoad imklog   # kernel logging (formerly provided by rklogd)

#
# Set the default permissions
#
\$FileOwner root
\$FileGroup admin
\$FileCreateMode 0640
\$DirCreateMode 0750
# \$Umask 0022

EOF

REMOTE_ENABLED=$(sys_params -l factory/options/logs/audit/remote/enabled)
# Set default in case EPAD is not running yet
[ -z "$REMOTE_ENABLED" ] && REMOTE_ENABLED="false"
REMOTE_SERVER=$(sys_params -l factory/options/logs/audit/remote/server)
REMOTE_PORT=$(sys_params -l factory/options/logs/audit/remote/port)

[ "$REMOTE_ENABLED" = "true" ] && cat << EOF
# Sends all messages of the local0 facility (Exor Audit log) to
# a TCP remote server with RFC5424 format (ietf-syslog-protocol-23)
local0.* action(
  type="omfwd"
  queue.type="linkedlist"
  action.resumeRetryCount="-1"
  queue.saveOnShutdown="on"
  template="RSYSLOG_SyslogProtocol23Format"
  target="$REMOTE_SERVER" port="$REMOTE_PORT" protocol="tcp"
)

EOF

cat << EOF
# Save local0 facility (Exor Audit log) messages only to audit in: IETF’s internet-draft
# ietf-syslog-protocol-23, which is very close to the actual syslog standard RFC5424
local0.*                        /var/log/audit/audit;RSYSLOG_SyslogProtocol23Format
& stop

#
# Some \`catch-all' logfiles.
#
*.=info;*.=notice;*.=warn;\\
        auth,authpriv.none;\\
        cron,daemon.none;\\
        mail,news.none          -/var/log/messages

#
# Emergencies are sent to everybody logged in.
#
*.emerg                         :omusrmsg:*

# Save boot messages also to boot.log
local7.*                        /var/log/boot.log

# Remote Logging (we use TCP for reliable delivery)
# An on-disk queue is created for this action. If the remote host is
# down, messages are spooled to disk and sent when it is up again.
#\$ActionQueueFileName uniqName # unique name prefix for spool files
#\$WorkDirectory /var/spool/rsyslog # where to place spool files
\$ActionQueueType Disk             # queue type disk
\$ActionQueueMaxDiskSpace 10m      # 10m space limit
\$ActionQueueCheckpointInterval 1  # no data can be lost
\$RepeatedMsgReduction on          # do not log repeated messages
#\$ActionQueueSaveOnShutdown on # save messages to disk on shutdown
#\$ActionQueueType LinkedList   # run asynchronously
#\$ActionResumeRetryCount -1    # infinite retries if host is down
# remote host is: name/ip:port, e.g. 192.168.0.1:514, port optional
#*.* @@remote-host:514


# ######### Receiving Messages from Remote Hosts ##########
# TCP Syslog Server:
# provides TCP syslog reception and GSS-API (if compiled to support it)
#\$ModLoad imtcp.so  # load module
#\$InputTCPServerRun 514 # start up TCP listener at port 514

# UDP Syslog Server (local Exor log):
\$ModLoad imudp.so               # provides UDP syslog reception
\$UDPServerAddress 127.0.0.1     # bind to localhost only
\$UDPServerRun 5144              # start a UDP syslog server at private port 5144

#
# Include all config files in /etc/rsyslog.d/
#
\$IncludeConfig /etc/rsyslog.d/*.conf
EOF
